package com.orangemarshall.hudproperty;

import com.orangemarshall.hudproperty.base.IAdvancedRenderer;
import com.orangemarshall.hudproperty.base.IBasicRenderer;
import com.orangemarshall.hudproperty.screen.AdvancedPropertyScreen;
import com.orangemarshall.hudproperty.screen.BasicPropertyScreen;
import com.orangemarshall.hudproperty.util.DelayedTask;

public final class HudPropertyAPI {
	
	private HudPropertyAPI(){}
	
	public static void open(IBasicRenderer renderer){
		new DelayedTask(() -> new BasicPropertyScreen(renderer));
	}
	
	public static void open(IAdvancedRenderer... renderer){
		new DelayedTask(() -> new AdvancedPropertyScreen(renderer));
	}
	
}
