package com.orangemarshall.hudproperty.example;

import com.orangemarshall.hudproperty.base.IAdvancedRenderer;
import com.orangemarshall.hudproperty.util.ScreenPosition;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;

public class ExampleAdvancedRenderer3 implements IAdvancedRenderer{

	private double x = 0;
	private double y = 0; 
	private String text = "HELLO WORLD";
	private FontRenderer fontRenderer;
	
	/*
	 * HudPropertyAPI.open(new ExampleListener());
	 * ^ to open the gui screen
	 */
	
	public ExampleAdvancedRenderer3() {
		fontRenderer = Minecraft.getMinecraft().fontRendererObj;
	}
	
	@Override
	public void save(ScreenPosition position) {
		Config.X_3 = position.getRelativeX();
		Config.Y_3 = position.getRelativeY();
	}

	@Override
	public ScreenPosition load() {
		return ScreenPosition.newRelative(Config.X_3, Config.Y_3);
	}

	@Override
	public void render(ScreenPosition position) {
		Minecraft.getMinecraft().fontRendererObj.drawString(text, position.getAbsoluteX(), position.getAbsoluteY(), 0xFFFFFF);
	}

	@Override
	public int getHeight() {
		return fontRenderer.FONT_HEIGHT;
	}

	@Override
	public int getWidth() {
		return fontRenderer.getStringWidth("HELLO WORLD");
	}

}
