package com.orangemarshall.hudproperty.screen;

import java.io.IOException;

import com.orangemarshall.hudproperty.base.IBasicRenderer;
import com.orangemarshall.hudproperty.util.ScreenPosition;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;

public class BasicPropertyScreen extends GuiScreen {

	private final IBasicRenderer renderer;
	private ScreenPosition position;
	private Minecraft mc;

	private int prevX, prevY;

	public BasicPropertyScreen(IBasicRenderer renderer){
		this.mc = Minecraft.getMinecraft();
		this.renderer = renderer;
		if((this.position = renderer.load()) == null){
			this.position = ScreenPosition.newAbsolute(5, 5);
		}
		checkBounds(position);	// Don't be outside of screen
		mc.displayGuiScreen(this);
	}

	@Override
	public void drawScreen(int x, int y, float partialTicks) {
		super.drawDefaultBackground();

		float zBackup = this.zLevel;
		this.zLevel = 200;

		renderer.render(position);

		super.drawScreen(x, y, partialTicks);

		this.zLevel = zBackup;
	}

	@Override
	protected void keyTyped(char c, int key) {
		if (key == 1) {
			renderer.save(position);
			this.mc.displayGuiScreen(null);
		}
	}

	@Override
	protected void mouseClicked(int x, int y, int button) throws IOException {
		prevX = x;
		prevY = y;
		super.mouseClicked(x, y, button);
	}

	@Override
	protected void mouseClickMove(int x, int y, int button, long time) {
		position.setAbsolute(position.getAbsoluteX() + x - prevX, y - prevY + position.getAbsoluteY());
		checkBounds(position);
		
		this.prevX = x;
		this.prevY = y;
		super.mouseClickMove(x, y, button, time);
	}

	@Override
	public void onGuiClosed() {
		renderer.save(position);
	}

	@Override
	public boolean doesGuiPauseGame() {
		return false;
	}

	private void checkBounds(ScreenPosition pos){
		ScaledResolution res = new ScaledResolution(mc);
		int width = res.getScaledWidth();
		int height = res.getScaledHeight();
		pos.setAbsolute(Math.max(0, Math.min(pos.getAbsoluteX(), width)), Math.max(0, Math.min(pos.getAbsoluteY(), height)));
	}
}
